<?php

namespace App\Http\Controllers;

use App\Models\Session;

class ActivitiesController extends Controller
{
    public function index()
    {
        $sessions = Session::with('sessionType')->get();

        $data = $sessions->map(function ($session) {
            return [
                'id' => $session->id,
                'title' => $session->title,
                'description' => $session->description,
                'type_name' => [
                        'name' => $session->sessionType->name,
                    ],
                'start_date' => $session->start_date,
                'end_date' => $session->end_date,
                'max_participants' => $session->max_participants,
                'created_at' => $session->created_at,
                'updated_at' => $session->updated_at,
            ];
        });

        return response()->json([
            'data' => $data
        ], 200);
    }

    public function show($id)
    {
        $session = Session::with('sessionType')->find($id);

        if (!$session) {
            return response()->json(['error' => 'Session not found'], 404);
        }

        $data = [
            'id' => $session->id,
            'title' => $session->title,
            'description' => $session->description,
            'type_name' => [
                'name' => $session->sessionType->name,
            ],
            'start_date' => $session->start_date,
            'end_date' => $session->end_date,
            'max_participants' => $session->max_participants,
            'created_at' => $session->created_at,
            'updated_at' => $session->updated_at,
        ];

        return response()->json([
            'messages' => 'Данные успешно получены',
            'data' => $data
        ], 200);
    }
}
