<?php

namespace App\Http\Controllers;

use App\Models\File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class HomeworkController extends Controller
{

    public function homework($id)
    {
        // Находим файл домашнего задания по ID сессии
        $file = File::where('session_id', $id)
            ->where('file_type', 'assignment')
            ->first();

        if (!$file) {
            return response()->json([
                'message' => 'Файл не найден.'
            ], 404);
        }

        // Путь к файлу через Storage
        $filePath = storage_path('app/public/' . $file->file_path);

        if (!file_exists($filePath)) {
            return response()->json([
                'message' => 'Файл отсутствует на сервере.'
            ], 404);
        }

        // Отправляем файл клиенту
        return response()->download($filePath, basename($file->file_path));
    }

    public function upload(Request $request, $id)
    {
        // Проверяем, что файл был передан
        if (!$request->hasFile('file')) {
            return response()->json([
                'message' => 'Файл не был загружен.'
            ], 400);
        }

        $file = $request->file('file');

        // Убедимся, что файл корректного типа (например, PDF, DOCX и т.д.)
        $allowedMimeTypes = ['application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'];
        if (!in_array($file->getMimeType(), $allowedMimeTypes)) {
            return response()->json([
                'message' => 'Неверный формат файла. Пожалуйста, загрузите PDF или Word документ.'
            ], 415);
        }

        // Устанавливаем путь для сохранения файла
        $uploadDir = 'uploads/homework/';
        $fileName = $file->getClientOriginalName();

        // Убираем лишние слэши
        $filePath = preg_replace('#/+#', '/', $uploadDir . $fileName);

        // Сохраняем файл в storage/app/public/uploads/homework/
        $file->storeAs('public/' . $uploadDir, $fileName);

        // Сохраняем информацию о файле в базу данных
        $fileModel = new File();
        $fileModel->user_id = Auth::guard('api')->id(); // ID пользователя
        $fileModel->session_id = $id; // ID сессии
        $fileModel->file_type = 'assignment'; // Тип файла
        $fileModel->file_path = $filePath;
        $fileModel->status = 'pending'; // Статус файла

        if ($fileModel->save()) {
            // Логирование (если необходимо)
            $fileModel->setLogs('Загрузка файла', 'Файл успешно отправлен');

            return response()->json([
                'data' => [
                    'message' => 'Файл успешно отправлен',
                ]
            ], 201);
        } else {
            return response()->json([
                'message' => 'Произошла ошибка при сохранении данных о файле.'
            ], 500);
        }
    }
}
