<?php

namespace App\Http\Controllers;

use App\Models\Log;
use Illuminate\Http\Request;

class LogController extends Controller
{
    public function index(Request $request)
    {
        // Получаем параметры user_id и action из запроса
        $userId = $request->query('user_id');
        $action = $request->query('action');

        // Получаем логи с фильтрацией или все логи, если параметры не переданы
        $query = Log::query();

        if ($userId) {
            $query->where('user_id', $userId);
        }

        if ($action) {
            $query->where('action', $action);
        }

        $logs = $query->get();

        // Формируем ответ
        $data = $logs->map(function ($log) {
            return [
                'id' => $log->id,
                'user' => [
                    'id' => $log->user_id,
                    'name' => $log->user->getFullName(),
                    'email' => $log->user->email,
                    'role' => [
                        'type' => $log->user->getRoles()
                    ]
                ],
                'action' => $log->action,
                'details' => $log->details,
                'timestamp' => $log->created_at,
                'ip_address' => $log->ip_address,
            ];
        });

        return response()->json([
            'data' => $data,
        ]);
    }
}
