<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Role;
use Illuminate\Http\Request;

class RoleController extends Controller
{
    
    
    public function roles(Request $request)
    {
        $roles = Role::get();
        $data = $roles->map(function ($user) {
            return [
                'id' => $user->id,
                'role' => $user->name
            ];
        });
        return response()->json([
            'messages' => 'Данные успешно получены',
            'data' => $data
        ]);
    }
    
    public function update(Request $request, $id)
    {
        // Загружаем данные пользователя
        $user = User::find($id);

        if (!$user) {
            return response()->json([
                'error' => [
                    'code' => 404,
                    'message' => 'Пользователь не найден'
                ]
            ], 404);
        }

        // Загружаем данные из запроса
        $data = $request->all();

        if (isset($data['role'])) {
            $role = $data['role'];

            // Здесь можно добавить проверку на допустимые роли (например, 'admin', 'user')
            if (!in_array($role, [1, 2])) {
                return response()->json([
                    'error' => [
                        'code' => 400,
                        'message' => 'Недопустимая роль'
                    ]
                ], 400);
            }

            // Обновляем роль пользователя
            $user->role_id = $role;
            if ($user->save()) {
                // Логирование (если необходимо)
                $user->setLogs('Пользователи', 'Роль пользователя успешно обновлена!');

                return response()->json([
                    'data' => [
                        'user' => [
                            'id' => $user->id,
                            'full_name' => $user->getFullName(),
                            'role' => $user->getRoles(),
                        ],
                        'code' => 200,
                        'message' => 'Роль пользователя успешно обновлена',
                    ],
                ], 200);
            } else {
                return response()->json([
                    'error' => [
                        'code' => 500,
                        'message' => 'Не удалось обновить роль пользователя'
                    ]
                ], 500);
            }
        }

        // Если роль не передана
        return response()->json([
            'error' => [
                'code' => 400,
                'message' => 'Роль не указана'
            ]
        ], 400);
    }
}
