<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;

class UserController extends Controller
{
    public function index()
    {
        $users = User::get();
        $data = $users->map(function ($user) {
            return [
                'id' => $user->id,
                'first_name' => $user->first_name,
                'last_name' => $user->last_name,
                'patronymic' => $user->patronymic,
                'email' => $user->email,
                'birth_date' => $user->birth_date,
                'status' => $user->getStatus(),
                'created_at' => $user->created_at,
                'updated_at' => $user->updated_at,
                'role' => $user->getRoles()
            ];
        });
        return response()->json([
            'messages' => 'Данные успешно получены',
            'data' => $data
        ]);
    }
}
