<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class File extends Model
{
    use HasFactory;

    protected $table = 'files';

    protected $fillable = [
        'user_id', 'session_id', 'file_type', 'file_path', 'uploaded_at', 'status'
    ];
    public $timestamps = false;
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function session()
    {
        return $this->belongsTo(Session::class);
    }

    public function setLogs($action, $details)
    {
        $logs = new Log();
        $logs->user_id = $this->id;
        $logs->action = $action;
        $logs->details = $details;
        $logs->ip_address = request()->ip();
        $logs->save();
    }
}
