<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class Role extends Model
{
    use HasFactory;

    protected $table = 'roles';

    protected $fillable = ['name'];

    public $timestamps = false;

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function setLogs($action, $details)
    {
        $logs = new Log();
        $logs->user_id = Auth::guard('api')->id();
        $logs->action = $action;
        $logs->details = $details;
        $logs->ip_address = request()->ip();
        $logs->save();
    }
}
