<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class Session extends Model
{
    use HasFactory;

    protected $table = 'sessions';

    protected $fillable = [
        'title', 'description', 'type_id', 'start_date', 'end_date', 'max_participants'
    ];

    public function sessionType()
    {
        return $this->belongsTo(SessionType::class, 'type_id');
    }

    public function userSessions()
    {
        return $this->hasMany(UserSession::class);
    }


    public function files()
    {
        return $this->hasMany(File::class);
    }

    public function setLogs($action, $details)
    {
        $logs = new Log();
        $logs->user_id = Auth::guard('api')->id();
        $logs->action = $action;
        $logs->details = $details;
        $logs->ip_address = request()->ip();
        $logs->save();
    }
}
