<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, Notifiable;

    protected $table = 'users';

    protected $fillable = [
        'first_name', 'last_name', 'patronymic', 'email', 'password_hash', 'role_id', 'birth_date', 'access_token', 'status'
    ];

    protected $hidden = [
        'password_hash', 'access_token',
    ];

    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    public function userSessions()
    {
        return $this->hasMany(UserSession::class);
    }

    public function files()
    {
        return $this->hasMany(File::class);
    }

    public function logs()
    {
        return $this->hasMany(Log::class);
    }

    public function getAuthToken()
    {
        return $this->access_token;
    }

    public function getStatus()
    {
        if ($this->status) {
            return 'Активный пользователь';
        } else {
            return 'Не активный пользователь';
        }
    }

    public function getRoles()
    {
        if ($this->role_id === 1) {
            return 'Администратор';
        } else {
            return 'Пользователь';
        }
    }

    public function getFullName(){
        return $this->first_name . ' ' . $this->last_name . ' ' . $this->patronymic;
    }


    public function setLogs($action, $details)
    {
        $logs = new Log();
        $logs->user_id = $this->id;
        $logs->action = $action;
        $logs->details = $details;
        $logs->ip_address = request()->ip();
        $logs->save();
    }
}
