<?php
/**
 * @author aleksejpuhov
 * File: FileFactory.php
 * Date: 01.02.2025
 * Time: 20:39
 */

namespace Database\Factories;

use App\Models\File;
use Illuminate\Database\Eloquent\Factories\Factory;

class FileFactory extends Factory
{
    protected $model = File::class;

    public function definition()
    {
        return [
            'user_id' => $this->faker->numberBetween(4, 6),
            'session_id' => $this->faker->numberBetween(1, 3),
            'file_type' => $this->faker->randomElement(['assignment', 'submission']),
            'file_path' => $this->faker->filePath,
            'status' => $this->faker->randomElement(['pending', 'reviewed']),
            'uploaded_at' => $this->faker->dateTime,
        ];
    }
}
