<?php
/**
 * @author aleksejpuhov
 * File: LogFactory.php
 * Date: 01.02.2025
 * Time: 20:40
 */

namespace Database\Factories;

use App\Models\Log;
use Illuminate\Database\Eloquent\Factories\Factory;

class LogFactory extends Factory
{
    protected $model = Log::class;

    public function definition()
    {
        return [
            'user_id' => $this->faker->numberBetween(4, 6),
            'action' => $this->faker->word,
            'details' => $this->faker->sentence,
            'ip_address' => $this->faker->ipv4,
            'created_at' => $this->faker->dateTime,
        ];
    }
}
