<?php
/**
 * @author aleksejpuhov
 * File: SessionFactory.php
 * Date: 01.02.2025
 * Time: 20:37
 */

namespace Database\Factories;

use App\Models\Session;
use Illuminate\Database\Eloquent\Factories\Factory;

class SessionFactory extends Factory
{
    protected $model = Session::class;

    public function definition()
    {
        return [
            'title' => $this->faker->sentence,
            'description' => $this->faker->paragraph,
            'type_id' => $this->faker->numberBetween(1, 3),
            'start_date' => $this->faker->dateTimeBetween('-1 month', 'now'),
            'end_date' => $this->faker->dateTimeBetween('now', '+1 month'),
            'max_participants' => $this->faker->numberBetween(1, 50),
        ];
    }
}
