<?php
/**
 * @author aleksejpuhov
 * File: UserSessionFactory.php
 * Date: 01.02.2025
 * Time: 20:38
 */

namespace Database\Factories;

use App\Models\UserSession;
use Illuminate\Database\Eloquent\Factories\Factory;

class UserSessionFactory extends Factory
{
    protected $model = UserSession::class;

    public function definition()
    {
        return [
            'user_id' => $this->faker->numberBetween(4, 6),
            'session_id' => $this->faker->numberBetween(1, 3),
            'status' => $this->faker->randomElement(['pending', 'approved', 'canceled']),
            'registered_at' => $this->faker->dateTime,
        ];
    }
}
