<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('session_types', function (Blueprint $table) {
            $table->id();
            $table->enum('name', ['Курсы', 'Мастер-класс', 'Индвидуальное занятие'])->unique();
            $table->timestamps();
        });

        DB::table('session_types')->insert([
            ['name' => 'Курсы'],
            ['name' => 'Мастер-класс'],
            ['name' => 'Индвидуальное занятие'],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('session_types');
    }
};
