<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Models\File;
use App\Models\Log;
use App\Models\Session;
use App\Models\UserSession;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Seed sessions
        Session::factory()->create(['title' => 'Session One', 'description' => 'Description for session one', 'type_id' => 1, 'start_date' => '2023-10-01 10:00:00', 'end_date' => '2023-10-01 12:00:00', 'max_participants' => 10]);
        Session::factory()->create(['title' => 'Session Two', 'description' => 'Description for session two', 'type_id' => 2, 'start_date' => '2023-10-02 10:00:00', 'end_date' => '2023-10-02 12:00:00', 'max_participants' => 15]);
        Session::factory()->create(['title' => 'Session Three', 'description' => 'Description for session three', 'type_id' => 3, 'start_date' => '2023-10-03 10:00:00', 'end_date' => '2023-10-03 12:00:00', 'max_participants' => 20]);

        // Seed user_sessions
        UserSession::factory()->create(['user_id' => 4, 'session_id' => 1, 'status' => 'approved']);
        UserSession::factory()->create(['user_id' => 5, 'session_id' => 2, 'status' => 'pending']);
        UserSession::factory()->create(['user_id' => 6, 'session_id' => 3, 'status' => 'canceled']);

        // Seed files
        File::factory()->create(['user_id' => 4, 'session_id' => 1, 'file_type' => 'assignment', 'file_path' => '/path/to/file1.pdf', 'status' => 'reviewed']);
        File::factory()->create(['user_id' => 5, 'session_id' => 2, 'file_type' => 'submission', 'file_path' => '/path/to/file2.pdf', 'status' => 'pending']);
        File::factory()->create(['user_id' => 6, 'session_id' => 3, 'file_type' => 'assignment', 'file_path' => '/path/to/file3.pdf', 'status' => 'reviewed']);

        // Seed logs
        Log::factory()->create(['user_id' => 4, 'action' => 'Login', 'details' => 'User logged in', 'ip_address' => '192.168.1.1']);
        Log::factory()->create(['user_id' => 5, 'action' => 'Register', 'details' => 'User registered for session', 'ip_address' => '192.168.1.2']);
        Log::factory()->create(['user_id' => 6, 'action' => 'Upload', 'details' => 'User uploaded a file', 'ip_address' => '192.168.1.3']);
    }
}
