<?php

use App\Http\Controllers\ActivitiesController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\HomeworkController;
use App\Http\Controllers\LogController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SessionController;
use App\Http\Controllers\UserController;
use App\Http\Middleware\EnsureAdmin;
use App\Http\Middleware\MalfinUnauthorized;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::post('registration', [AuthController::class, 'register']);
Route::post('authorization', [AuthController::class, 'login']);


Route::middleware([MalfinUnauthorized::class])->group(function () {
    Route::get('logout', [AuthController::class, 'logout']);

    // Курсы для обычного пользователя
    Route::get('activities/available', [ActivitiesController::class, 'index']);
    Route::get('activities/select/{id}', [ActivitiesController::class, 'show']);
    Route::get('activities/{id}/homework', [HomeworkController::class, 'homework']);
    Route::get('activities/search', [SessionController::class, 'search']);

    // Администратор
    Route::post('activities/{id}/homework/upload', [HomeworkController::class, 'upload'])->middleware([EnsureAdmin::class]);

    // Курсы
    Route::post('activities/create', [SessionController::class, 'create'])->middleware([EnsureAdmin::class]);
    Route::delete('activities/{id}/delete', [SessionController::class, 'delete'])->middleware([EnsureAdmin::class]);
    Route::put('activities/{id}/update', [SessionController::class, 'update'])->middleware([EnsureAdmin::class]);

    // Пользователь
    Route::get('users', [UserController::class, 'index'])->middleware([EnsureAdmin::class]);

    // Смена роли
    Route::patch('users/{id}/role', [RoleController::class, 'update'])->middleware([EnsureAdmin::class]);
    Route::get('users/roles', [RoleController::class, 'roles'])->middleware([EnsureAdmin::class]);

    // Просмотр логов
    Route::get('/logs', [LogController::class, 'index'])->middleware([EnsureAdmin::class]);
});

